module net.BurtonRadons.spyl.expressionValue;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** A constant value expression. */
class ValueExpression : Expression
{
    Value value; /**< Value of the expression. */
    
    /** Assign the parameters. */
    this (Mark mark, Value value)
    {
        super (mark);
        this.value = value;
    }
    
    override Value evaluate (Scope scope)
    {
        return value;
    }
    
    char [] toString ()
    {
        return value.toString ();
    }
    
    override int precedence ()
    {
        return Precedence.Primary;
    }
}
